//
//  Ad_Response.h
//  Open_Falls_Lib
//  Author Suganya A
//  Created by Suganya A on 20/06/17.
//  Copyright © 2017 Vrtcal. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <CoreTelephony/CTCarrier.h>			
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#include <ifaddrs.h>
#include <arpa/inet.h>
#import <AddressBook/AddressBook.h>
#import <CoreLocation/CoreLocation.h>


#import "AdConfiguration.h"

extern NSString     *notification_desc;
extern NSString     *notification_title;
extern NSString    *impurl;

//extern NSString     *ad_subtype;
//extern int           adwidthval;
//extern int           adheightval;
//extern NSString *keywords;


//The below url used to identify the package name
#define dJAX_BASE_HOSTNAME @"http://dkmadsnetwork.com/api/request_sdk.php?"//client

//#define dJAX_BASE_HOSTNAME @"http://13.234.135.218/dkmads/api/request_sdk.php?"//client
//#define dJAX_BASE_HOSTNAME @"http://stage01.infomo.ws/api/request_sdk.php?"//client
//#define dJAX_BASE_HOSTNAME @"https://staging.djaxbidder.com/addevelop/api/request_sdk.php?"
//zoneid=404,403,405
//zoneid=501
//#define dJAX_BASE_HOSTNAME @"http://dev.djaxtech.com/DAC125/GEO/multizone.php?"//infomo

//#define dJAX_BASE_HOSTNAME @"http://3.6.142.117/addevelop/api/request_sdk.php?"//infomo
//#define dJAX_BASE_HOSTNAME @"https://adtech.djaxtech.com/api/request_sdk.php?"//infomo

//#define dJAX_BASE_HOSTNAME @"http://dev.djaxtech.com/DAC125/GEO/ios_geo_static.php?"
//#define dJAX_BASE_HOSTNAME @"http://dev.djaxtech.com/DAC125/GEO/Tesr.php?"//zone 1

//Native DelegateProtocolMethod
@protocol AdServerCommunicatorDelegate <NSObject>


- (void)communicatorDidReceiveAdConfiguration1:(AdConfiguration *)configuration;

@end

//Reward DelegateProtocolMethod
@protocol RewardDelegate <NSObject>
- (void) Rewarditem:(NSString *) reward withArg2:(int)rewardvalue;
- (void)communicatorDidReceiveAdConfiguration1:(NSDictionary *)configuration;
-(void) Rewarditem:(NSArray *) rewards;

@end
//.
///reward delegate

@protocol AdResponseViewControllerDelegate <UIGestureRecognizerDelegate>
@optional
-(void)handleRequestresponse:(NSString *)loadUrl Responseurl:(NSDictionary *)response;

@end

@interface Ad_Response : UIViewController <UIGestureRecognizerDelegate,UIWebViewDelegate>
@property (nonatomic, assign) id<AdServerCommunicatorDelegate> delegate;
@property (nonatomic, strong) id <AdResponseViewControllerDelegate> AdResponseViewDelegate;

@property (nonatomic, strong)UIWebView *adView;

//delegate to call method when event occurs
@property (nonatomic, assign) id<RewardDelegate> RewardDelegate;
- (void) dJAXreward;
- (id)initWithDelegate:(id<AdServerCommunicatorDelegate>)delegate;
//delegate end

@property(nonatomic, strong)UIWebView *web;


@property (nonatomic, strong) NSTimer *timer;




/// Refresh the native ad.
@property(nonatomic, weak) IBOutlet UIButton *refreshButton;




- (IBAction)refreshAd:(id)sender;





extern NSDictionary *native_val;
//Reward Implementation
extern NSString    *clickurl;
extern NSString     *adtag_value;
extern NSDictionary *jsonObjects;
extern NSString     *adtype;
extern NSString *videoAdtag;
extern NSString     *ads_value;
extern NSString     *AdResponse;
extern NSString     *positionurljson;
//.
-(UIWebView *)PassZoneid:(int)zoneid  isRewardDelegate:(NSString *)adrequestvalue;
-(UIWebView *)PassZoneid:(int)zoneid  isRewardDelegate:(NSString *)adrequestvalue gender:(NSString *)Gender age:(int)Age phoneNumber:(NSString *)Phoneno email:(NSString *)Email;
-(UIWebView *)PassZoneid:(int)zoneid  isRewardDelegate:(NSString *)adrequestvalue customTargeting:(NSMutableDictionary *)customparams;
- (UIWebView *)PassZoneid:(int)zoneid PassCoordinateXAxis:(float)coordinatex PassCoordinateYAxis:(float)coordinatey PassFrameWidth:(float)framewidth PassFrameHeight:(float)frameheight;
- (UIWebView *)PassZoneid:(int)zoneid gender:(NSString *)Gender age:(int)Age phoneNumber:(NSString *)Phoneno email:(NSString *)Email PassCoordinateXAxis:(float)coordinatex PassCoordinateYAxis:(float)coordinatey PassFrameWidth:(float)framewidth PassFrameHeight:(float)frameheight;
- (UIWebView *)PassZoneid:(NSString *)zoneid customTargeting:(NSMutableDictionary *)customparams setKeyword:(NSString *)keyword PassCoordinateXAxis:(float)coordinatex PassCoordinateYAxis:(float)coordinatey PassFrameWidth:(float)framewidth PassFrameHeight:(float)frameheight;

//PassCache
- (UIWebView *)PassZoneid:(NSString *)zoneid PassCacheSeconds:(double)cachetime customTargeting:(NSMutableDictionary *)customparams setKeyword:(NSString *)keyword PassCoordinateXAxis:(float)coordinatex PassCoordinateYAxis:(float)coordinatey PassFrameWidth:(float)framewidth PassFrameHeight:(float)frameheight;

- (UIWebView *)PassZoneid:(int)zoneid customTargeting:(NSMutableDictionary *)customparams PassCoordinateXAxis:(float)coordinatex PassCoordinateYAxis:(float)coordinatey PassFrameWidth:(float)framewidth PassFrameHeight:(float)frameheight;

-(UIWebView *)PassZoneid:(NSString *)zoneid ;

//Passcache 
-(UIWebView *)PassZoneid:(NSString *)zoneid PassCacheSeconds:(double)cachetime;

- (UIWebView *)PassZoneid:(int)zoneid customTargeting:(NSMutableDictionary *)customparams ;
- (UIWebView *)PassZoneid:(NSString *)zoneid customTargeting:(NSMutableDictionary *)customparams setKeyword:(NSString *)keyword PassCacheSeconds:(double)cachetime;
- (UIWebView *)PassZoneid:(NSString *)zoneid customTargeting:(NSMutableDictionary *)customparams setKeyword:(NSString *)keyword PassCacheSeconds:(double)cachetime;
//setKeyword:(NSString *)keyword
//-(UIWebView *)TargetLoadAd:(id)targetobj PassZoneid:(int)zoneid;

- (void)downloadedData:(id)data;
- (void)rewardedVideoAdShouldRewardForAdUnitID:(NSString *)adUnitID reward:(NSDictionary *)reward;
-(void)AutoRefreshTargetController:(SEL)selectorname AutoRefreshTimeInterval:(int)TimeInterval;
-(UIWebView *) PassZoneid:(int)zoneid  gender:(NSString *)Gender age:(int)Age phoneNumber:(NSString *)Phoneno email:(NSString *)Email;

//-(UIWebView *)TargetLoadAd:(id)targetobj PassZoneid:(int)zoneid;
- (void) Mediation_tracking:(NSString *)url;
-(void)interstitial_ad;


@end

